#
# Read current measured values from values.json
#
# Requirements: Python 3.6.1 ( www.python.org )
#               Hx5xx device with firmware version 9-5-0-1 or higher
#
#  Purpose of this example is demonstration of communication with Hx5xx device.
#  It is not intended to be used in production environment without further changes.
#

#Connection parameters
TCP_IP = '192.168.1.213'

import urllib.request, json

#read JSON file from device
r = urllib.request.urlopen("http://"+TCP_IP+"/values.json")
c = r.read(2048).decode("ISO-8859-1")

#decode JSON
j = json.loads(c)

#print values from channels
for ch in ["ch1", "ch2", "ch3", "ch4"]:
    print(j[ch]["name"]+": "+j[ch]["aval"]+j[ch]["unit"])
