﻿#
# Control relay example
#
# Requirements: Python 3.6.1 ( www.python.org )
# 		Enabled far control for relay in device setup
#               Hx5xx device with firmware version 9-5-0-0 or higher
#
#  Purpose of this example is demonstration of communication with Hx5xx device.
#  It is not intended to be used in production environment without further changes.
#

#Connection parameters
TCP_IP = '192.168.1.213'
TCP_PORT = 502

import socket, struct

sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.connect((TCP_IP, TCP_PORT))

try:
    # 0x41 - relay 1
    # 0x42 - relay 2
    relay = 0x41
    
    # 0 - relay under Hx5xx device control
    # 1 - close relay
    # 2 - open relay
    state = 1
    
    req = struct.pack('12B', 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x06, 0x00, relay, 0x00, state )
    #send ModbusTCP request
    sock.send(req)
    '''
    Modbus TCP request:
       0x00 0x00 0x00 0x00 - transaction ID + protocol ID
       0x00 0x06           - length of following bytes
       0x01                - unit ID
       0x06                - function code (write single register)
       0x00 relay          - register address (from manual - 0x41 or 0x42)
       0x00 state          - register value (from manual - 0, 1 or 2)
    '''
    print("Done");
    
finally:
    sock.close()
