<%@ WebService Language="C#" Class="WebSensorWebServiceExamples.HxxxxCO2V2" %>

//
// Read SOAP message example for devices with CO2 measurement
//
// Requirements: Hx5xx device with CO2 measurement (H5524, H6520, H5521, H6521) and firmware version 9-5-0-0 or higher
//               IIS 7 server
//
//  Purpose of this example is demonstration of communication with Hx5xx device.
//  It is not intended to be used in production environment without further changes.
//


using System.IO;
using System.Text;
using System.Web.Services;
using System.Web.Services.Protocols;

namespace WebSensorWebServiceExamples
{
  /// <summary>
  /// Example of collecting SOAP messages from Hxxxx CO2 V2 Web Sensor.
  /// Edit constant FILENAME to requested ouptut file location.
  /// </summary>
  [WebService(Namespace = "http://cometsystem.cz/schemas/soapHx5xxCO2_v2.xsd")]
  [SoapDocumentService(RoutingStyle = SoapServiceRoutingStyle.RequestElement)]
  public class HxxxxCO2V2 : System.Web.Services.WebService
  {
    public const string FILENAME = @"d:\HxxxxCO2V2.txt";

    [WebMethod(Description = "Example of processing sample from Hxxxx sensor.")]
    public bool InsertHx5xxCO2SampleV2(
      string passKey,
      string device,
      string temp,
      string relHum,
      string compQuant,
      string co2,
      string alarms1,
      string alarms2,
      string re1,
      string re2,
      string lev1,
      string lev2,
      string lev3,
      string compType,
      string tempU,
      string timer)
    {
      StringBuilder sb = new StringBuilder();
      sb.AppendLine(string.Format("passKey: {0}", passKey));
      sb.AppendLine(string.Format("device: {0}", device));
      sb.AppendLine(string.Format("temp: {0}", temp));
      sb.AppendLine(string.Format("relHum: {0}", relHum));
      sb.AppendLine(string.Format("compQuant: {0}", compQuant));
      sb.AppendLine(string.Format("co2: {0}", co2));
      sb.AppendLine(string.Format("alarms1: {0}", alarms1));
      sb.AppendLine(string.Format("alarms2: {0}", alarms2));
      sb.AppendLine(string.Format("re1: {0}", re1));
      sb.AppendLine(string.Format("re2: {0}", re2));
      sb.AppendLine(string.Format("lev1: {0}", lev1));
      sb.AppendLine(string.Format("lev2: {0}", lev2));
      sb.AppendLine(string.Format("lev3: {0}", lev3));
      sb.AppendLine(string.Format("compType: {0}", compType));
      sb.AppendLine(string.Format("tempU: {0}", tempU));
      sb.AppendLine(string.Format("timer: {0}", timer));

      if (File.Exists(FILENAME))
        File.Delete(FILENAME);
      File.WriteAllText(FILENAME, sb.ToString());

      return true;
    }
  }
}
