<?php
#
# Read SOAP message example for devices with CO2 measurement
#
# Requirements: Hx5xx device with CO2 measurement (H5524, H6520, H5521, H6521) and firmware version 9-5-0-0 or higher
#               Apache server (tested with version 2.4.23)
#               PHP (tested with version 5.6.25)
#               Enabled SOAP extension for PHP
#               Uncommented line always_populate_raw_post_data = -1 in php.ini file
#
#  Purpose of this example is demonstration of communication with Hx5xx device.
#  It is not intended to be used in production environment without further changes.
#

function InsertHx5xxCO2SampleV2($passKey,$device,
                                $temp,$relHum,$compQuant,$co2,
                                $alarms1,$alarms2,
                                $re1,$re2,
                                $lev1,$lev2,$lev3,
                                $compType,$tempU,$timer) {

 $txt = "Time: ".StrFTime("%y-%m-%d %H:%M:%S", Time()).", Temp: ".$temp.", RH: ".$relHum.", CQ: ".$compQuant.", CO2: ".$co2."\r\n";

 $myfile = fopen("logs.txt", "a");
 fwrite($myfile, $txt);
 fclose($myfile);
}

$server = new SoapServer(null, array('uri' => "http://test-uri/"));
$server->addFunction('InsertHx5xxCO2SampleV2');
$server->handle();
?>
