#
# Simple UDP Syslog server
#
# Requirements: Python 3.6.1 ( www.python.org )
#               Hx5xx device with firmware version 9-5-0-0 or higher
#               Allowed port in firewall
#
#  Purpose of this example is demonstration of communication with Hx5xx device.
#  It is not intended to be used in production environment without further changes.
#

from socket import *

# UDP port for Syslog server
PORT = 514

# Create socket and bind
UDPSock = socket(AF_INET, SOCK_DGRAM)
UDPSock.bind(("", PORT))
print('Starting Syslog server...')

# Receive messages
while 1:
    data,addr = UDPSock.recvfrom(1024)
    print("Syslog message '", data.decode(), "'")
