#
# Read current measured values from values.xml
#
# Requirements: Python 3.6.1 ( www.python.org )
#               Hx5xx device with firmware version 9-5-0-0 or higher
#
#  Purpose of this example is demonstration of communication with Hx5xx device.
#  It is not intended to be used in production environment without further changes.
#

#Connection parameters
TCP_IP = '192.168.1.213'

import urllib.request, sys
import xml.etree.ElementTree as ET

#read XML file from device
r = urllib.request.urlopen("http://"+TCP_IP+"/values.xml")
xmldoc = ET.fromstring(r.read(2048))

#check state of <err> tag
if xmldoc[0].text == "1":
    print("Values are not available!")
    sys.exit()

#values from elements with tags <unit>
for child in xmldoc:
    if child.findall("unit"):
        print(child[0].text+":", child[2].text, child[1].text)
