<?php

// ------------------------------------------------------------
// Ulogger online data receiver script
// ------------------------------------------------------------

// VERSION 1:

// Change only implementation of ProcessParsedData function. Leave the code bellow unchanged.
// This will ensure that information about parsing the JSON returns back to the device
// in known format for the device.

// For debug purposses (when you sends dummy JSON data from app and you can view the response
// of the script) change WANT_DEBUG to 1 to get detailed response.

// Actually, ProcessParsedData() function contains example code, that writes parsed data to file d:\output.txt.

// Response format (when WANT_DEBUG = 0):
// "[0]" - successfully received
// "[c, n1, n2, n3, n4]" - error response:
// c - error code
// n1..n4 indexes to item in JSON data that caused the error 

//VERSION 2:

// Functions LogError, LogPostData and LogResponse was added:
// LogError - enables logging of error
// LogPostData - enables logging of request post data
// LogResponseDetail - enables logging of responses to the device

// You can enable/disable their calling by setting flags: $LOG_ERROR, $LOG_POST_DATA, $LOG_RESPONSE

// Also, you can edit their content to do it your way

include "Classes.php";

$OUTPUT_FILE = 'output.txt';
const WANT_DEBUG = 0;
$LOG_ERROR = true;
$LOG_POST_DATA = false;
$LOG_RESPONSE = false;

function ProcessParsedData($device, $outputfile)
{
  $fileHandle = fopen($outputfile, 'a') or die("File creation error.");
  try
  {
    fwrite($fileHandle, "\r\n". gmdate("Y-m-d H:i:s") . " UTC " . " PROCESSED DATA\r\n" . "------------------------------------------------------------" . "\r\n");
//    fwrite($fileHandle, "SERVER['HTTPS']" . "=" . $_SERVER['HTTPS']);
//    fwrite($fileHandle, "SERVER['SERVER_PORT']" . "=" . $_SERVER['SERVER_PORT']);
    fwrite($fileHandle, DeviceHelper::ToString($device));
  }
  finally
  {
    fclose($fileHandle);
  }
  // example of processing <--
}
function LogError($exception, $outputfile)
{
  $fileHandle = fopen($outputfile, 'a') or die("File creation error.");
  try
  {
    fwrite($fileHandle, "\r\n". gmdate("Y-m-d H:i:s") . " UTC " . " ERROR OCCURED\r\n" . "------------------------------------------------------------" . "\r\n");
    fwrite($fileHandle, $exception->ToString() . "\r\n");
  }
  finally
  {
    fclose($fileHandle);
  }
}
function LogPostData($postData, $outputfile)
{
  $fileHandle = fopen($outputfile, 'a') or die("File creation error.");
  try
  {
    fwrite($fileHandle, "\r\n". gmdate("Y-m-d H:i:s") . " UTC " . " POST DATA\r\n" . "------------------------------------------------------------" . "\r\n");
    fwrite($fileHandle, $postData . "\r\n");
  }
  finally
  {
    fclose($fileHandle);
  }
}
function LogResponse($response, $outputfile)
{
  $fileHandle = fopen($outputfile, 'a') or die("File creation error.");
  try
  {
    fwrite($fileHandle, "\r\n". gmdate("Y-m-d H:i:s") . " UTC " . " POST DATA\r\n" . "------------------------------------------------------------" . "\r\n");
    fwrite($fileHandle, $response);
  }
  finally
  {
    fclose($fileHandle);
  }
}


// ------------------------------------------------------------
// Do not change the code bellow...
// ------------------------------------------------------------
$device = null;
$exception = null;
try
{
  $postData = file_get_contents("php://input");
  if ($LOG_POST_DATA)
    LogPostData($postData, $OUTPUT_FILE);
  $device = DeviceHelper::Parse($postData);
}
catch (ParseException $e)
{
  $exception = $e;
}
catch (Exception $e)
{
  $exception = new ParseException($e->getMessage);
}

try
{
  if ($exception == null)
    ProcessParsedData($device, $OUTPUT_FILE);
}
catch (Exception $e)
{
  $exception = new ParseException($e->getMessage(), ERROR_CODE_PROCESING_OF_PARSED_DATA_FAILED);
}

if ($exception != null)
  try
  {
    if ($LOG_ERROR)
      LogError($exception, $OUTPUT_FILE);
  }
  catch (Exception $e) {}


$response = null;
if ($exception == null)
{
  if (WANT_DEBUG == 1)
    $response = "Successfully received.";
  else
    $response = "[0]";
}
else
{
  if (WANT_DEBUG == 1)
    $response = "Error occured: " . $exception->ToString();
  else
    $response = $exception->GetJSONShortDetail();
}

if ($LOG_RESPONSE)
  LogResponse($response, $OUTPUT_FILE);

exit($response);
?>